/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FrameLayout
extends ViewGroup {
    private final List<View> matchParentChildren = new ArrayList<View>(1);

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.MarginLayoutParams lp;
        View child;
        int i;
        this.matchParentChildren.clear();
        int count = this.getChildCount();
        boolean measureMatchParentChildren = MeasureSpec.getMode(widthMeasureSpec).isVariable() || MeasureSpec.getMode(heightMeasureSpec).isVariable();
        int maxWidth = 0;
        int maxHeight = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.matchParentChildren.add(child);
        }
        maxWidth = Math.max(maxWidth, this.getMinWidth());
        maxHeight = Math.max(maxHeight, this.getMinHeight());
        this.setMeasuredDimension(FrameLayout.resolveSize(maxWidth, widthMeasureSpec), FrameLayout.resolveSize(maxHeight, heightMeasureSpec));
        count = this.matchParentChildren.size();
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                child = this.matchParentChildren.get(i);
                lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth() - lp.leftMargin - lp.rightMargin);
                    childWidthMeasureSpec = MeasureSpec.makeMeasureSpec(width, MeasureSpec.Mode.EXACTLY);
                } else {
                    childWidthMeasureSpec = FrameLayout.getChildMeasureSpec(widthMeasureSpec, lp.leftMargin + lp.rightMargin, lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight() - lp.topMargin - lp.bottomMargin);
                    childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(height, MeasureSpec.Mode.EXACTLY);
                } else {
                    childHeightMeasureSpec = FrameLayout.getChildMeasureSpec(heightMeasureSpec, lp.topMargin + lp.bottomMargin, lp.height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    @Override
    protected void onLayout(boolean changed) {
        int count = this.getChildCount();
        int parentLeft = 0;
        int parentRight = this.getWidth();
        int parentTop = 0;
        int parentBottom = this.getHeight();
        int parentWidth = this.getWidth();
        int parentHeight = this.getHeight();
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            int horizontalGravity = gravity & 7;
            int verticalGravity = gravity & 0x70;
            switch (horizontalGravity) {
                case 1: {
                    childLeft = parentLeft + (parentWidth - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = parentRight - width - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            switch (verticalGravity) {
                case 16: {
                    childTop = parentTop + (parentHeight - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams convertLayoutParams(@Nonnull ViewGroup.LayoutParams params) {
        if (params instanceof LayoutParams) {
            return params;
        }
        if (params instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)params);
        }
        return new LayoutParams(params);
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams createDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams params) {
        return params instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = 51;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(@Nonnull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nonnull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nonnull LayoutParams source) {
            super(source);
            this.gravity = source.gravity;
        }

        @Override
        @Nonnull
        public LayoutParams copy() {
            return new LayoutParams(this);
        }
    }
}

